/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

/* 
 * zephyr mann
 * 2014
 */

float pWid = 120.;
float pHei = 100.;

float getDepth(vec2 uv) {
    float x = (uv.x - (iResolution.x*0.5)) / iResolution.x;
	float y = (uv.y - (iResolution.y*0.5)) / iResolution.x;
    
    float offX = sin(iGlobalTime * 1.) * 0.2;
    float offY = cos(iGlobalTime * 0.666) * 0.2;
    
    float d = floor(abs(y*2. + offY + sin((x+iGlobalTime*0.25)*10.) * 0.25) * 20.) * 0.05;
    d = 1. - d;
    d = 1. - (d*d*d*d);
    
    return d;
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float maxStep = 30.;
    float d = 0.;
    
    vec2 uv = fragCoord.xy;
    
    for(int count = 0; count < 100; count++) {
        if(uv.x < pWid)
          break;
        
        float d = getDepth(uv);
        //d = 1.;
        
        uv.x -= pWid - (d * maxStep);
    }
    
    float x = mod(uv.x + iGlobalTime*1., pWid) / pWid;
    float y = mod(uv.y + iGlobalTime*4., pHei) / pHei;
    vec3 rgb = texture2D( iChannel0, vec2(x,y), -100.0 ).yxz;
    
	fragColor = vec4(rgb,1.0);
    
    // view depth map
    if(false)
    	fragColor = vec4(vec3(getDepth(fragCoord.xy)),1.0);
        
    
    // add some guide dots
    float dotWid = min(iResolution.y * 0.01, 5.0);
    uv.x = (fragCoord.x - (iResolution.x*0.5));
    uv.y = (fragCoord.y - (iResolution.y*0.5));
    
    if(distance(uv, vec2(maxStep*1.5,0.0)) < dotWid || distance(uv, vec2(-maxStep*1.5,0.0)) < dotWid)
        fragColor = vec4(0.0);
}

void main ( void )
{
  mainImage( gl_FragColor, gl_FragCoord.xy );
}